/*
 * Decompiled with CFR 0.152.
 */
package renamegui;

import java.awt.Desktop;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import renamegui.DescriptionScreen;
import renamegui.PreRenameLogic;
import renamegui.RenameGUI;
import renamegui.RenameLogic;
import renamegui.WordItem;
import renamegui.Wordlist;
import renamegui.settingsWindow;

public class Controller
implements Initializable {
    @FXML
    private Text actiontarget;
    @FXML
    private Label bigLabel;
    @FXML
    private TextArea consoleArea;
    @FXML
    private TextArea errorConsoleArea;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private TableView tableView;
    @FXML
    private CheckBox subFolderCheckBox;
    @FXML
    private Button execute;
    @FXML
    private Button deleteStringButton;
    @FXML
    private TextField dirField;
    @FXML
    private TextField newString;
    @FXML
    private Button showFiles;
    DirectoryChooser chooser = new DirectoryChooser();
    Stage stage;
    private int currentNumOfWords;

    @FXML
    public void init(String DPath, String ticked_value) {
        this.currentNumOfWords = 0;
        boolean success = Wordlist.loadWordlist();
        if (!success) {
            this.out(RenameGUI.rb.getString("wordlistreadfail"));
        } else {
            this.out(RenameGUI.rb.getString("wordlistreadsuccess"));
        }
        ObservableList data = this.tableView.getItems();
        for (String s : Wordlist.getItems()) {
            ++this.currentNumOfWords;
            data.add((Object)new WordItem(s, this.currentNumOfWords));
        }
        this.chooser.setTitle(RenameGUI.rb.getString("pleaseselectfoler"));
        if (DPath.equals("none") || DPath.isEmpty()) {
            this.setDefaultDir(System.getProperty("user.dir"));
        } else {
            this.setDefaultDir(DPath);
        }
        if (ticked_value.equals("true")) {
            this.subFolderCheckBox.setSelected(true);
        } else {
            this.subFolderCheckBox.setSelected(false);
        }
        this.listener();
    }

    public void listener() {
        this.tableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<WordItem>(){

            public void changed(ObservableValue<? extends WordItem> observable, WordItem oldValue, WordItem newValue) {
                Controller.this.deleteStringButton.setDisable(false);
                WordItem selected = (WordItem)Controller.this.tableView.getSelectionModel().getSelectedItem();
                if (selected != null) {
                    System.out.println(RenameGUI.rb.getString("selectedstring") + ":" + selected.getWord());
                } else {
                    System.out.println("Table Cleared!");
                }
            }
        });
    }

    public void setDefaultDir(String str) {
        File defaultDirectory = new File(str);
        if (defaultDirectory.exists()) {
            this.chooser.setInitialDirectory(defaultDirectory);
        } else {
            this.out(RenameGUI.rb.getString("cantaccessdefaultpath"));
            this.chooser.setInitialDirectory(new File(System.getProperty("user.dir")));
        }
        File path = this.chooser.getInitialDirectory();
        this.dirField.setText(path.getPath());
    }

    @FXML
    public void exit() {
        System.exit(0);
    }

    @FXML
    public void showHowTo() {
        DescriptionScreen ds = new DescriptionScreen();
        ds.show();
    }

    @FXML
    private void showVerInfo() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(RenameGUI.rb.getString("versioninfo"));
        alert.setHeaderText(null);
        alert.setContentText(RenameGUI.rb.getString("programname") + "\n" + RenameGUI.rb.getString("copyrightinfo") + "\n" + RenameGUI.rb.getString("websiteurl"));
        alert.showAndWait();
    }

    @FXML
    private void showSettingsWindow() {
        settingsWindow.show();
    }

    @FXML
    private void showSite() {
        Controller.openWebpage(RenameGUI.rb.getString("websiteurl"));
    }

    public static void openWebpage(String urlString) {
        try {
            Desktop.getDesktop().browse(new URL(urlString).toURI());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @FXML
    private void showFiles() {
        String path = !this.chooser.getInitialDirectory().getPath().isEmpty() ? this.chooser.getInitialDirectory().getPath() : System.getProperty("user.dir");
        this.errorConsoleArea.clear();
        this.consoleArea.clear();
        this.out(RenameGUI.rb.getString("currentdirectory") + " = " + path + "\n");
        PreRenameLogic PreRL = new PreRenameLogic(this.progressBar, this.consoleArea, this.errorConsoleArea, this.execute, this.showFiles, path, this.subFolderCheckBox.isSelected());
        PreRL.start();
    }

    @FXML
    private void pickDirectory() {
        File chosenFolder = this.chooser.showDialog((Window)this.stage);
        if (chosenFolder != null) {
            this.chooser.setInitialDirectory(chosenFolder);
        }
        if (this.chooser.getInitialDirectory() != null) {
            this.dirField.setText(this.chooser.getInitialDirectory().toString());
        }
    }

    public void out(String outString) {
        this.consoleArea.appendText(outString + "\n");
    }

    @FXML
    public void registerWord() {
        ObservableList data = this.tableView.getItems();
        if (this.newString.getText().equals("")) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setTitle(RenameGUI.rb.getString("warning"));
            alert.setHeaderText(null);
            alert.setContentText(RenameGUI.rb.getString("pleaseentersearchstring"));
            alert.showAndWait();
        } else {
            data.add((Object)new WordItem(this.newString.getText(), this.currentNumOfWords + 1));
            this.writeToWordlist((ObservableList<WordItem>)data);
            ++this.currentNumOfWords;
            this.newString.clear();
        }
    }

    @FXML
    public void deleteWord() {
        Object a = this.tableView.getSelectionModel().getSelectedItem();
        this.tableView.getItems().removeAll(new Object[]{a});
        WordItem b = (WordItem)a;
        System.out.println("Removed:" + b.getWord());
        this.writeToWordlist((ObservableList<WordItem>)this.tableView.getItems());
    }

    @FXML
    public void execute() {
        RenameLogic RLRename = new RenameLogic(this.progressBar, this.consoleArea, this.execute, PreRenameLogic.parentfilepath, PreRenameLogic.filenames, PreRenameLogic.howmanyfiles);
        RLRename.start();
    }

    private void writeToWordlist(ObservableList<WordItem> data) {
        ArrayList<String> words = new ArrayList<String>();
        for (WordItem b : data) {
            System.out.println("Registered:" + b.getWord());
            words.add(b.getWord());
        }
        Wordlist.writeWordlist(words);
    }

    public void initialize(URL location, ResourceBundle resources) {
    }
}

