/*
 * Decompiled with CFR 0.152.
 */
package renamegui;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import renamegui.RenameGUI;
import renamegui.Wordlist;

public class PreRenameLogic
extends Thread {
    public static String[] filenames;
    public static String[] parentfilepath;
    public static int howmanyfiles;
    private int CountF = 0;
    private final int MAX_FILES = 10000;
    private final boolean SET_MAX = false;
    private String matome;
    private String errorMatome;
    TextArea consoleTextArea;
    TextArea errorConsoleTextArea;
    Button doit;
    private String FILEPATH;
    private boolean INCLUDE_SUBDIR;
    ProgressBar progressBar;
    Button showFiles;

    PreRenameLogic(ProgressBar pb, TextArea ta, TextArea eta, Button btn, Button shw, String path, boolean include_subdirectory) {
        this.progressBar = pb;
        this.consoleTextArea = ta;
        this.errorConsoleTextArea = eta;
        this.doit = btn;
        this.showFiles = shw;
        this.FILEPATH = path;
        this.INCLUDE_SUBDIR = include_subdirectory;
    }

    @Override
    public void run() {
        this.doit.setDisable(true);
        this.showFiles.setDisable(true);
        this.progressBar.setVisible(true);
        this.RegisterFiles(this.FILEPATH, this.INCLUDE_SUBDIR);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PreRenameLogic.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.doit.setDisable(false);
        this.showFiles.setDisable(false);
        this.progressBar.setVisible(false);
    }

    private void errorAppend(String error) {
        this.errorMatome = this.errorMatome + error;
    }

    private void RegisterFiles(String path, boolean include_subdirectory) {
        if (Wordlist.wordlist_exists()) {
            Wordlist.loadWordlist();
            this.matome = "";
            this.errorMatome = "";
            howmanyfiles = 0;
            this.CountFiles(path, 10000, false, include_subdirectory);
            this.CountF = 0;
            filenames = new String[howmanyfiles];
            parentfilepath = new String[howmanyfiles];
            this.RegFiles(path, 10000, false, include_subdirectory);
            if (howmanyfiles > 0) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PreRenameLogic.this.errorConsoleTextArea.appendText(PreRenameLogic.this.errorMatome);
                        PreRenameLogic.this.consoleTextArea.appendText(PreRenameLogic.this.matome);
                        PreRenameLogic.this.consoleTextArea.appendText("\n" + RenameGUI.rb.getString("prerename1") + String.valueOf(howmanyfiles) + " " + RenameGUI.rb.getString("prerename2") + "\n");
                        PreRenameLogic.this.doit.setVisible(true);
                    }
                });
            } else {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PreRenameLogic.this.errorConsoleTextArea.appendText(PreRenameLogic.this.errorMatome);
                        PreRenameLogic.this.consoleTextArea.appendText(RenameGUI.rb.getString("nomatchingfilesfound") + "\n");
                        PreRenameLogic.this.doit.setVisible(false);
                    }
                });
            }
            this.CountF = 0;
        } else {
            this.errorAppend(RenameGUI.rb.getString("error") + ": " + RenameGUI.rb.getString("wordlistreadfail"));
        }
    }

    private void CountFiles(String filePath, int maxFiles, boolean setmax, boolean include_subdirectory) {
        Path dir = FileSystems.getDefault().getPath(filePath, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    int once = 0;
                    String name = path.getFileName().toString();
                    for (String out : Wordlist.getItems()) {
                        if (!name.contains(out) || once != 0) continue;
                        System.out.println(path.toString());
                        this.matome = this.matome + path.toString() + "\n";
                        ++howmanyfiles;
                        ++once;
                    }
                    if (++this.CountF <= maxFiles || !setmax) continue;
                    break;
                }
                if (!include_subdirectory) continue;
                this.CountFiles(path.toString(), maxFiles - this.CountF, setmax, include_subdirectory);
            }
            stream.close();
        }
        catch (AccessDeniedException ex) {
            System.out.println(ex.toString());
            this.errorAppend(RenameGUI.rb.getString("accessdenied") + ": " + ex.getFile() + "\n");
        }
        catch (DirectoryIteratorException ex) {
            System.out.println(ex.toString());
            this.errorAppend(RenameGUI.rb.getString("error") + "@CountFiles\uff1a" + ex.toString() + "\n");
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            this.errorAppend(RenameGUI.rb.getString("error") + "@CountFiles\uff1a" + ex.toString() + "\n");
        }
    }

    private void RegFiles(String filePath, int maxFiles, boolean setmax, boolean include_subdirectory) {
        int howmany = 0;
        Path dir = FileSystems.getDefault().getPath(filePath, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    int once = 0;
                    String name = path.getFileName().toString();
                    for (String out : Wordlist.getItems()) {
                        if (!name.contains(out) || once != 0) continue;
                        PreRenameLogic.filenames[howmany] = name;
                        PreRenameLogic.parentfilepath[howmany] = path.getParent().toString();
                        ++howmany;
                        ++once;
                    }
                    if (++this.CountF <= maxFiles || !setmax) continue;
                    break;
                }
                if (!include_subdirectory) continue;
                this.RegFiles(path.toString(), maxFiles - this.CountF, setmax, include_subdirectory);
            }
            stream.close();
        }
        catch (AccessDeniedException ex) {
            System.out.println(ex.toString());
        }
        catch (DirectoryIteratorException ex) {
            System.out.println(ex.toString());
            this.errorAppend(RenameGUI.rb.getString("error") + "@RegistertFiles\uff1a" + ex.toString() + "\n");
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
            this.errorAppend(RenameGUI.rb.getString("error") + "@RegisterFiles\uff1a" + ex.toString() + "\n");
        }
    }

    static {
        howmanyfiles = 0;
    }
}

